VERSION 5.00
Begin VB.Form CustAddr 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Customer address"
   ClientHeight    =   3855
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   7020
   ControlBox      =   0   'False
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   3855
   ScaleWidth      =   7020
   StartUpPosition =   2  'CenterScreen
   Begin VB.TextBox txt_CCUDesc 
      Height          =   315
      Left            =   1380
      TabIndex        =   16
      Top             =   780
      Width           =   5440
   End
   Begin VB.Frame fra_Item 
      BorderStyle     =   0  'None
      Height          =   2430
      Left            =   60
      TabIndex        =   7
      Top             =   1260
      Width           =   7020
      Begin Project1.ArmCombobox cbo_country 
         Height          =   345
         Left            =   4320
         TabIndex        =   15
         Top             =   1920
         Width           =   2445
         _ExtentX        =   4313
         _ExtentY        =   609
      End
      Begin Project1.ArmCombobox cbo_County 
         Height          =   345
         Left            =   4320
         TabIndex        =   14
         Top             =   1560
         Width           =   2445
         _ExtentX        =   4313
         _ExtentY        =   609
      End
      Begin VB.TextBox txt_Desc 
         Height          =   315
         Left            =   1320
         MaxLength       =   80
         TabIndex        =   1
         Top             =   195
         Width           =   5445
      End
      Begin VB.TextBox txt_Addr1 
         Height          =   315
         Left            =   1155
         MaxLength       =   80
         TabIndex        =   2
         Top             =   855
         Width           =   5610
      End
      Begin VB.TextBox txt_Addr2 
         Height          =   330
         Left            =   1155
         MaxLength       =   80
         TabIndex        =   3
         Top             =   1200
         Width           =   5610
      End
      Begin VB.TextBox txt_Town 
         Height          =   315
         Left            =   1155
         MaxLength       =   80
         TabIndex        =   4
         Top             =   1560
         Width           =   2160
      End
      Begin VB.TextBox txt_Zip1 
         Height          =   315
         Left            =   1155
         MaxLength       =   10
         TabIndex        =   5
         Top             =   1905
         Width           =   1065
      End
      Begin VB.TextBox txt_Zip2 
         Height          =   315
         Left            =   2250
         MaxLength       =   10
         TabIndex        =   6
         Top             =   1905
         Width           =   1065
      End
      Begin VB.Label lbl_Desc 
         Caption         =   "#Description"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   300
         Left            =   60
         TabIndex        =   13
         Tag             =   "lbl_cadesc"
         Top             =   225
         Width           =   1095
      End
      Begin VB.Label lbl_Address 
         Caption         =   "#Address"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   300
         Left            =   60
         TabIndex        =   12
         Tag             =   "lbl_CAAddress"
         Top             =   900
         Width           =   1170
      End
      Begin VB.Label lbl_Town 
         Caption         =   "#Town"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   300
         Left            =   60
         TabIndex        =   11
         Tag             =   "lbl_CATown"
         Top             =   1620
         Width           =   885
      End
      Begin VB.Label lbl_County 
         Caption         =   "#County"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   300
         Left            =   3420
         TabIndex        =   10
         Tag             =   "lbl_CACounty"
         Top             =   1620
         Width           =   900
      End
      Begin VB.Label lbl_zip 
         Caption         =   "#Zip code"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   300
         Left            =   60
         TabIndex        =   9
         Tag             =   "lbl_CAZip"
         Top             =   1965
         Width           =   990
      End
      Begin VB.Label lbl_Country 
         Caption         =   "#Country"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   300
         Left            =   3420
         TabIndex        =   8
         Tag             =   "lbl_CACountry"
         Top             =   1965
         Width           =   810
      End
   End
   Begin Project1.ToolBr pbItem 
      Align           =   1  'Align Top
      Height          =   675
      Left            =   0
      TabIndex        =   0
      Top             =   0
      Width           =   7020
      _ExtentX        =   12383
      _ExtentY        =   1191
   End
   Begin VB.Label lbl_CCU 
      Caption         =   "#Customer"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   300
      Left            =   120
      TabIndex        =   17
      Tag             =   "lbl_ccu"
      Top             =   840
      Width           =   1095
   End
End
Attribute VB_Name = "CustAddr"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Enum ArmErr
    DBCnxFailed = vbObjectError + 1             ' Unable to connect to the database
    CPTAlreadyInitialized = vbObjectError + 2   ' We try to initialize a component that is already initialized
    CPTNotInitialized = vbObjectError + 3       ' We try to use or free that is not initialized yet
    InvalidArgument = vbObjectError + 4
    PropertyNotSet = vbObjectError + 5
    SQLFailure = vbObjectError + 6               ' A SQL runtime error has occured : syntax wrong....
    SQLBadRowAffectedCount = vbObjectError + 7   ' A SQL request has not affected the expected rowcount (ex: one Update do nothing)
    SQLBadRowExpectedCount = vbObjectError + 8   ' A SQL request does not return the expected rowcount : select an item return nothing...
    DrivingError = vbObjectError + 9
    CompFncFailed = vbObjectError + 10           ' when component function fail
    GridLoadFailed = vbObjectError + 11          ' load function failed ... bad sql
    QuietException = vbObjectError + 12          ' do not display error message
    SQLTableReferenceConstraint = vbObjectError + 13 ' A SQL request cannot be executed : Table reference constraint
    DuplicityDetected = vbObjectError + 2301     ' detected row with same unique id
End Enum


'******** Curseur de connexion
Private mo_ArmDb As Object
Private mb_use_framework_connection As Boolean
Private mb_Created As Boolean
Private ms_ConnectString As String
Private ms_UID As String
Private mt_CstValues As Type_CstValues

Private m_Language As String

Private mi_DisplayMode As Integer

Private ms_CA_Code As String
Private ms_CCU_CapKey As String
Private ms_CCU_CapDesc As String

Private p_iConc As Integer

Private m_CountryCode As String
Private m_CountryDesc As String
Private m_CountyCode As String
Private m_CountyDesc As String
Private ms_OldCodeCountry  As String

Public Property Set ArmDb(ByRef ao_local_connection As Object)

    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "CustAddr:ArmDb_Set"
    #End If
    CapMouseOff
    
    If Not (ao_local_connection Is Nothing) Then
        mb_use_framework_connection = True
        Set mo_ArmDb = ao_local_connection
        
        Set pbItem.ArmDb = mo_ArmDb
        Set cbo_County.ArmDb = mo_ArmDb
        Set cbo_country.ArmDb = mo_ArmDb
    End If

Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "CustAddr:ArmDb_Set"
    #End If
    CapMouseOn
End Property

Property Let ConnectString(as_ConnectString As String)
    
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "CustAddr:ConnectString_Let", "as_ConnectString=" & as_ConnectString
    #End If
    CapMouseOff
    
    ms_UID = ConnectionStringValidation(as_ConnectString)
    If ms_UID = "" Then GoTo Trace_End
    
    ms_ConnectString = as_ConnectString
    
    pbItem.ConnectString = ms_ConnectString
    cbo_County.ConnectString = ms_ConnectString
    cbo_country.ConnectString = ms_ConnectString
    
Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "CustAddr:ConnectString_Let"
    #End If
    CapMouseOn
End Property

Property Let Language(as_LanguageCode As String)
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "CustAddr:Language_Let", "as_LanguageCode=" & as_LanguageCode
    #End If
    
    m_Language = as_LanguageCode
    pbItem.Language = as_LanguageCode
    
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "CustAddr:Language_Let"
    #End If
End Property

Sub SetCountry(ACodeValue As String, ADescValue)
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "CustAddr:SetCountry", "ACodeValue=" & ACodeValue, "ADescValue=" & ADescValue
    #End If
    
    If ms_CCU_CapKey = "" Then GoTo Trace_End
    m_CountryCode = ACodeValue
    m_CountryDesc = ADescValue
    
Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "CustAddr:SetCountry"
    #End If
End Sub

Sub SetCounty(ACodeValue As String, ADescValue)
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "CustAddr:SetCounty", "ACodeValue=" & ACodeValue, "ADescValue=" & ADescValue
    #End If
    
    If ms_CCU_CapKey = "" Then GoTo Trace_End
    m_CountyCode = ACodeValue
    m_CountyDesc = ADescValue
    
Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "CustAddr:SetCounty"
    #End If
End Sub

Property Let CountyDesc(aValue As String)
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "CustAddr:CountyDesc_Let", "AValue=" & aValue
    #End If
    
    m_CountyDesc = aValue
    
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "CustAddr:CountyDesc_Let"
    #End If
End Property

Property Let CA_Code(ACode As String)
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "CustAddr:CA_Code_Let", "ACode=" & ACode
    #End If
    
    ms_CA_Code = ACode
    
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "CustAddr:CA_Code_Let"
    #End If
End Property

Property Let CCU_CapKey(ACode As String)
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "CustAddr:CCU_CapKey_Let", "ACode=" & ACode
    #End If
    
    ms_CCU_CapKey = ACode
    
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "CustAddr:CCU_CapKey_Let"
    #End If
End Property

Property Let CCU_CapDesc(ADesc As String)
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "CustAddr:CCU_CapDesc_Let", "ADesc=" & ADesc
    #End If
    
    ms_CCU_CapDesc = ADesc
    
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "CustAddr:CCU_CapDesc_Let"
    #End If
End Property

Property Let DisplayMode(ai_DisplayMode As Integer)
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "CustAddr:DisplayMode_Let", "ai_DisplayMode=" & ai_DisplayMode
    #End If
    
    mi_DisplayMode = ai_DisplayMode
    
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "CustAddr:DisplayMode_Let"
    #End If
End Property

Function RecordAdd() As Boolean
Dim ls_Request As String
Dim lb_Result As Boolean
Dim ls_Result As String

    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "CustAddr:RecordAdd"
    #End If
    
    RecordAdd = False
    
    If ms_CCU_CapKey = "" Then GoTo Trace_End
    
    ErrorOFF

    Dim ls_CA_Code As String
    ls_CA_Code = mo_ArmDb.SQLNextID("Cap_CustomerAddress")
    If ls_CA_Code = "" Then Call Err.Raise(SQLFailure, "", "SQL Error: mo_ArmDb.SQLNextID(""Cap_CustomerAddress"") return nothing.")

    ls_Request = "Exec Cap_CustomerAddress_ins "
    
    ls_Request = ls_Request & "  " & "'" & ms_CCU_CapKey & "'" '@CCU_CapKey char (16),
    ls_Request = ls_Request & ", " & CorrectString(mo_ArmDb, m_Language, txt_Addr1, True) '@CA_addr1 char (10),
    ls_Request = ls_Request & ", " & CorrectString(mo_ArmDb, m_Language, txt_Addr2) '@CA_addr2 char (10),
    ls_Request = ls_Request & ", " & CorrectString(mo_ArmDb, m_Language, txt_Zip1, True) '@CA_zip1 char (10),
    ls_Request = ls_Request & ", " & CorrectString(mo_ArmDb, m_Language, txt_Zip2) '@CA_zip2 char (10),
    ls_Request = ls_Request & ", " & CorrectString(mo_ArmDb, m_Language, txt_Town, True) '@CA_town varchar (80),
    ls_Request = ls_Request & ", " & CorrectCodeInt(mo_ArmDb, m_Language, cbo_County, True) '@CTY_code int ,
    ls_Request = ls_Request & ", " & CorrectCodeStr(mo_ArmDb, m_Language, cbo_country, True) '@CT_code char (4),
    ls_Request = ls_Request & ", " & CorrectString(mo_ArmDb, m_Language, txt_Desc, True) '@CA_desc varchar (80),
    ls_Request = ls_Request & ", " & "''" '@Internet CHAR(1),
    ls_Request = ls_Request & ", " & "''" '@Drop CHAR(1),
    ls_Request = ls_Request & ", " & "NULL" '@Drop_date DATETIME,
    ls_Request = ls_Request & ", " & "NULL" '@spare1_varchar VARCHAR(1),
    ls_Request = ls_Request & ", " & "NULL" '@spare2_varchar VARCHAR(1),
    ls_Request = ls_Request & ", " & "NULL" '@spare3_real REAL,
    ls_Request = ls_Request & ", " & "NULL" '@spare4_real REAL
    ls_Request = ls_Request & ",'" & ls_CA_Code & "'"
    
    'Execution
    If ErrorFound Then GoTo Trace_End
    
    If Not ASC_ConnectToDB(mo_ArmDb, ms_ConnectString, mb_Created) Then GoTo Trace_End
    
    Dim lb_Transaction As Boolean
    ASC_BeginTransaction mo_ArmDb
    lb_Transaction = True
    
    lb_Result = ASC_RecordExec(mo_ArmDb, ls_Request, ls_CA_Code)
    
    If lb_Result = False Then
        ASC_RollBackTransaction mo_ArmDb
        lb_Transaction = False
        Call ASC_SendMessage(mo_ArmDb, m_Language, 891, "#An error occured during this manipulation, please contact your IT support")
        GoTo Trace_End
    End If
    
    ASC_CommitTransaction mo_ArmDb
    lb_Transaction = False
    RecordAdd = True
    
Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "CustAddr:RecordAdd", "Result=" & RecordAdd
    #End If
    CapMouseOn
    Exit Function
    
Trace_Err:
    If lb_Transaction Then
        ASC_RollBackTransaction mo_ArmDb
    End If
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "CustAddr:RecordAdd"
    CapMouseOn
End Function

Function RecordUpdate() As Boolean
Dim ls_Request As String
Dim lb_Result As Boolean
Dim ls_Result As String

    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "CustAddr:RecordUpdate"
    #End If
    
    RecordUpdate = False
    
    If ms_CCU_CapKey = "" Then GoTo Trace_End
    If ms_CA_Code = "" Then GoTo Trace_End
    
    ErrorOFF

    ls_Request = "Exec Cap_CustomerAddress_upd "
    
    ls_Request = ls_Request & "  " & "'" & ms_CA_Code & "'" '@CA_code char (16),
    ls_Request = ls_Request & ", " & "'" & ms_CCU_CapKey & "'" '@CA_code char (16),
    ls_Request = ls_Request & ", " & CorrectString(mo_ArmDb, m_Language, txt_Addr1, True) '@CA_addr1 char (10),
    ls_Request = ls_Request & ", " & CorrectString(mo_ArmDb, m_Language, txt_Addr2) '@CA_addr2 char (10),
    ls_Request = ls_Request & ", " & CorrectString(mo_ArmDb, m_Language, txt_Zip1, True) '@CA_zip1 char (10),
    ls_Request = ls_Request & ", " & CorrectString(mo_ArmDb, m_Language, txt_Zip2) '@CA_zip2 char (10),
    ls_Request = ls_Request & ", " & CorrectString(mo_ArmDb, m_Language, txt_Town, True) '@CA_town varchar (80),
    ls_Request = ls_Request & ", " & CorrectCodeInt(mo_ArmDb, m_Language, cbo_County, True) '@CTY_code int ,
    ls_Request = ls_Request & ", " & CorrectCodeStr(mo_ArmDb, m_Language, cbo_country, True) '@CT_code char (4),
    ls_Request = ls_Request & ", " & CorrectString(mo_ArmDb, m_Language, txt_Desc, True) '@CA_desc varchar (80),
    ls_Request = ls_Request & ", " & p_iConc 'iConc
    ls_Request = ls_Request & ", " & "''" '@Internet CHAR(1),
    ls_Request = ls_Request & ", " & "''" '@Drop CHAR(1),
    ls_Request = ls_Request & ", " & "NULL" '@Drop_date DATETIME,
    ls_Request = ls_Request & ", " & "NULL" '@spare1_varchar VARCHAR(1),
    ls_Request = ls_Request & ", " & "NULL" '@spare2_varchar VARCHAR(1),
    ls_Request = ls_Request & ", " & "NULL" '@spare3_real REAL,
    ls_Request = ls_Request & ", " & "NULL" '@spare4_real REAL
    
    'Execution
    If ErrorFound Then GoTo Trace_End
    
    If Not ASC_ConnectToDB(mo_ArmDb, ms_ConnectString, mb_Created) Then GoTo Trace_End
    
    ASC_BeginTransaction mo_ArmDb
    
    lb_Result = ASC_RecordExec(mo_ArmDb, ls_Request, ls_Result)
    If lb_Result = False Then
        ASC_RollBackTransaction mo_ArmDb
        Select Case ls_Result
            Case "-2"
                Call ASC_SendMessage(mo_ArmDb, m_Language, 916, "#This data has been updated by another user. Data will be reloaded. Please check the data and try again.")
                ViewInitFields
            Case Else
                Call ASC_SendMessage(mo_ArmDb, m_Language, 891, "#An error occured during this manipulation, please contact your IT support")
        End Select
        GoTo Trace_End
    End If
    
    ASC_CommitTransaction mo_ArmDb
    RecordUpdate = True
    
Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "CustAddr:RecordUpdate", "Result=" & RecordUpdate
    #End If
    CapMouseOn
    Exit Function
    
Trace_Err:
    ASC_RollBackTransaction mo_ArmDb
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "CustAddr:RecordUpdate"
    CapMouseOn
End Function

Function RecordDelete() As Boolean
Dim ls_Request As String
Dim lb_Result As Boolean
Dim ls_Result As String

    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "CustAddr:RecordDelete"
    #End If
    
    RecordDelete = False
    
    If ms_CCU_CapKey = "" Then GoTo Trace_End
    If ms_CA_Code = "" Then GoTo Trace_End
    
    ErrorOFF

    ls_Request = "Exec Cap_CustomerAddress_del "
    
    ls_Request = ls_Request & "  " & "'" & ms_CA_Code & "'" '@CA_code char (16),
    ls_Request = ls_Request & ", " & "'" & ms_CCU_CapKey & "'"
    ls_Request = ls_Request & ", " & p_iConc
    
    'Execution
    If ErrorFound Then GoTo Trace_End
    
    If DeleteConfirmation(mo_ArmDb, m_Language) = False Then GoTo Trace_End
    
    If Not ASC_ConnectToDB(mo_ArmDb, ms_ConnectString, mb_Created) Then GoTo Trace_End
    
    ASC_BeginTransaction mo_ArmDb
    
    lb_Result = ASC_RecordExec(mo_ArmDb, ls_Request, ls_Result)
    If lb_Result = False Then
        ASC_RollBackTransaction mo_ArmDb
        If ls_Result = "-1" Then
            Call ASC_SendMessage(mo_ArmDb, m_Language, 916, "#This data has been updated by another user. Data will be reloaded. Please check the data and try again.")
            ViewInitFields
        Else
            Call ASC_SendMessage(mo_ArmDb, m_Language, 891, "#An error occured during this manipulation, please contact your IT support")
        End If
        GoTo Trace_End
    End If
    
    ASC_CommitTransaction mo_ArmDb
    RecordDelete = True
    
Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "CustAddr:RecordDelete", "Result=" & RecordDelete
    #End If
    CapMouseOn
    Exit Function
    
Trace_Err:
    ASC_RollBackTransaction mo_ArmDb
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "CustAddr:RecordDelete"
    CapMouseOn
End Function

Private Sub BlankFields()
    'Default values, we are in Add !!
    
    txt_Addr1.Text = ""
    txt_Addr2.Text = ""
    txt_CCUDesc.Text = ms_CCU_CapDesc
    txt_Desc.Text = ""
    txt_Town.Text = ""
    txt_Zip1.Text = ""
    txt_Zip2.Text = ""
    
    cbo_country.Clear
    cbo_country.AddItem Array(m_CountryCode, m_CountryDesc), True
    cbo_County.Clear
    cbo_County.AddItem Array(m_CountyCode, m_CountyDesc), True
    
End Sub

Private Sub ViewInitFields()
Dim ll_Cursor As Long
Dim TheRequest As String

    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "CustAddr:ViewInitFields"
    #End If
    
    'Si pas de cl en cours, ca veut dire qu'on est en ajout
    If ms_CCU_CapKey = "" Then GoTo Trace_End
    
    'Try connexion
    If Not ASC_ConnectToDB(mo_ArmDb, ms_ConnectString, mb_Created) Then GoTo Trace_End
        
    TheRequest = "exec Cap_CustomerAddress_t_sel  NULL, '" & ms_CCU_CapKey & "', '" & m_Language & "'"
    ll_Cursor = mo_ArmDb.OpenSQL(TheRequest, -1, 0)
    If ll_Cursor = 0 Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceSQLError mo_ArmDb, "CustAddr:ViewInitFields", "Request=" & TheRequest
        GoTo Trace_End
    End If
  
    'Does it exist ?
    ms_CA_Code = ""
    ms_CA_Code = mo_ArmDb.GetFields(ll_Cursor, "CA_Code")
  
    If ms_CA_Code = "" Then
                        GoTo Trace_End
    End If

    p_iConc = mo_ArmDb.GetFields(ll_Cursor, "iConcurrency")
        
    txt_Desc.Text = mo_ArmDb.GetFields(ll_Cursor, "CA_desc")
    txt_Addr1.Text = mo_ArmDb.GetFields(ll_Cursor, "CA_addr1")
    txt_Addr2.Text = mo_ArmDb.GetFields(ll_Cursor, "CA_addr2")
    txt_Zip1.Text = mo_ArmDb.GetFields(ll_Cursor, "CA_zip1")
    txt_Zip2.Text = mo_ArmDb.GetFields(ll_Cursor, "CA_zip2")
    txt_Town.Text = mo_ArmDb.GetFields(ll_Cursor, "CA_town")
    
    cbo_country.AddItem Array(CStr(mo_ArmDb.GetFields(ll_Cursor, "CT_Code")), mo_ArmDb.GetFields(ll_Cursor, "CT_Desc")), True
    cbo_County.AddItem Array(CStr(mo_ArmDb.GetFields(ll_Cursor, "CTY_Code")), mo_ArmDb.GetFields(ll_Cursor, "CTY_Desc")), True
   
Trace_End:
    mo_ArmDb.Close ll_Cursor
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "CustAddr:ViewInitFields"
    #End If
    CapMouseOn
    Exit Sub
    
Trace_Err:
    mo_ArmDb.Close ll_Cursor
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "CustAddr:ViewInitFields"
    CapMouseOn
End Sub

Public Sub InitializeToolBar()

    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "CustAddr:InitializeToolBar"
    #End If
    
   pbItem.ClearAllIcons
    'We test CA_Code to know if the data exist in the database
   If ms_CA_Code = "" Then
        If mi_DisplayMode = mt_CstValues.DisplayMode_Add Or mi_DisplayMode = mt_CstValues.DisplayMode_Update Then
            pbItem.PictureDisplayed = "P_Valid=1 P_Undo=2 P_Quit=-1"
            GoTo Trace_End
        End If
    End If
         
         Select Case mi_DisplayMode
             Case mt_CstValues.DisplayMode_Update
        pbItem.PictureDisplayed = "P_Valid=1 P_Undo=2 P_Delete=4 P_Quit=-1"
             Case mt_CstValues.DisplayMode_Delete
                 pbItem.PictureDisplayed = "P_Quit=-1"
             Case mt_CstValues.DisplayMode_View
                 pbItem.PictureDisplayed = "P_Update=3 P_Delete=4 P_Quit=-1"
         End Select
   
Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "CustAddr:InitializeToolBar"
    #End If
    CapMouseOn
    Exit Sub
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "CustAddr:InitializeToolBar"
    CapMouseOn
End Sub

Private Sub cbo_country_ComboItemSelected()
    
    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "CustAddr:cbo_country_ComboItemSelected"
    #End If
    
    cbo_County.Clear
    ms_OldCodeCountry = ""

Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "CustAddr:cbo_country_ComboItemSelected"
    #End If
    CapMouseOn
    Exit Sub
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "CustAddr:cbo_country_ComboItemSelected"
    CapMouseOn
End Sub

Public Sub Load_A_Com()
    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "CustAddr:Load_A_Com"
    #End If
    
    Set mt_CstValues = New Type_CstValues
    
    VerifyInitialization mo_ArmDb, ms_ConnectString, m_Language, Me

    pbItem.Load_A_Com
    cbo_County.Load_A_Com
    cbo_country.Load_A_Com

    cbo_country.FirstBlankItem = False
    cbo_country.Request = "exec countries_cbo6 " & "'" & m_Language & "'"
    cbo_County.FirstBlankItem = False
    ms_OldCodeCountry = ""
    cbo_County.Request = ""

    'Initialize the screen constant of the form
    LoadLabels mo_ArmDb, Me.Controls, "Cap_Customer_Postal", m_Language

    BlankFields
    ViewInitFields
    EnableInitFields
    InitializeToolBar

Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "CustAddr:Load_A_Com"
    #End If
    CapMouseOn
    Exit Sub
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "CustAddr:Load_A_Com"
    CapMouseOn
End Sub

Private Sub EnableInitFields()

    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "CustAddr:EnableInitFields"
    #End If
    
    lbl_CCU.Enabled = False
    txt_CCUDesc.Enabled = False
    
    'We test CA_Code to know if the data exist in the database
    If ms_CA_Code = "" Then
        If mi_DisplayMode = mt_CstValues.DisplayMode_Add Or mi_DisplayMode = mt_CstValues.DisplayMode_Update Then
            txt_Desc.Text = ms_CCU_CapDesc
            ControlsEnable Me.Controls, fra_item, True
            GoTo Trace_End
        End If
    End If
    
    Select Case mi_DisplayMode
        Case mt_CstValues.DisplayMode_Update
            ControlsEnable Me.Controls, fra_item, True
            
        Case mt_CstValues.DisplayMode_Delete
            ControlsEnable Me.Controls, fra_item, False
        
        Case mt_CstValues.DisplayMode_View
            ControlsEnable Me.Controls, fra_item, False
        Case Else '????
            ControlsEnable Me.Controls, fra_item, False
    End Select
    
Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "CustAddr:EnableInitFields"
    #End If
    CapMouseOn
    Exit Sub
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "CustAddr:EnableInitFields"
    CapMouseOn
End Sub

Public Sub Unload_A_Com()

    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "CustAddr:Unload_A_Com"
    #End If
    
    Set mt_CstValues = Nothing
    
    pbItem.Unload_A_Com
    cbo_County.Unload_A_Com
    cbo_country.Unload_A_Com

    ASC_DisconnectFromDB mo_ArmDb, ms_UID, mb_Created

Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "CustAddr:Unload_A_Com"
    #End If
    CapMouseOn
    Exit Sub
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "CustAddr:Unload_A_Com"
    CapMouseOn
End Sub

Private Sub cbo_county_ComboBeforeDropDown()
Dim CodeCountry As String

    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "CustAddr:cbo_county_ComboBeforeDropDown"
    #End If
    
    'On charge les county
    CodeCountry = GetCodeFromCombo(cbo_country)
    If CodeCountry <> "" Then
        If ms_OldCodeCountry <> CodeCountry Then
            cbo_County.FirstBlankItem = False
            cbo_County.Request = "exec cap_county_cbo  '" & CodeCountry & "', " & "'" & m_Language & "'"
            ms_OldCodeCountry = CodeCountry
        End If
    End If

Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "CustAddr:cbo_county_ComboBeforeDropDown"
    #End If
    CapMouseOn
    Exit Sub
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "CustAddr:cbo_county_ComboBeforeDropDown"
    CapMouseOn
End Sub

Private Sub pbItem_action(ByVal as_ActionType As String)

    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "CustAddr:pbItem_action", "as_ActionType=" & as_ActionType
    #End If
    
    Select Case as_ActionType
        Case "Delete"
            If RecordDelete Then
                Me.Hide
            End If
            
        Case "Update"
            mi_DisplayMode = mt_CstValues.DisplayMode_Update
            pbItem.ClearAllIcons
            pbItem.PictureDisplayed = "P_Valid=1 P_Undo=2 P_Quit=-1"
            EnableInitFields
    
        Case "Quit"
            Unload Me
    
        Case "Undo"
            BlankFields
            ViewInitFields
             
        Case "Valid"
            'We test CA_Code to know if the data exist in the database
            If ms_CA_Code = "" Then
                If RecordAdd Then Me.Hide
            Else
                If RecordUpdate Then
                    Me.Hide
                End If
            End If
        
    End Select

Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "CustAddr:pbItem_action"
    #End If
    CapMouseOn
    Exit Sub
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "CustAddr:pbItem_action"
    CapMouseOn
End Sub
